//////////////////////////////////////////////////////////////////////////////////////////////
// sept_heimdall_include - Heimdall include file
//
// Based on Crom's work.
//--------------------------------------------------------------------------------------------
// Last modified by :  	Septirage		2025/09/13
//////////////////////////////////////////////////////////////////////////////////////////////

#include "nwnx_msgServer"

void Heimdall_ModuleInit();
int Heimdall_IsRemembered(string sPlayerName, string sIP, string sCDKey, int iPrivileges);
string Heimdall_GetRegisteredAccount(string sPlayerName, string sIP, string sCDKey, int iPrivileges);
string Heimdall_IsLoginAllowed(string sPlayerName, string sIP, string sCDKey, int iPrivileges);
string Heimdall_RegisterNewAccount(string sPlayerName, string sIP, string sCDKey, int iPrivileges, string sPassword);
int Heimdall_CheckPasswordMatch(string sPlayerName, string sIP, string sCDKey, int iPrivileges, string sPassword);
void Heimdall_RememberPlayer(string sPlayerName, string sIP, string sCDKey, int iPrivileges);
string Heimdall_CheckAccountPolicy(string sPlayerName, string sIP, string sCDKey, int iPrivileges);
string Heimdall_CheckPasswordPolicy(string sPlayerName, string sIP, string sCDKey, int iPrivileges, string sPassword);
void Heimdall_ShowErrorMessage(int iUniquePlayerID, string SCENENAME, string sPlayer, string sIP, string sCDKey, int iPrivileges, string sMsg);
void Heimdall_OpenMsgGUI(int iUniquePlayerID, string sPlayerName, string sIP, string sCDKey, int iPrivileges, string sMessage);
void Heimdall_OpenLoginGUI(int iUniquePlayerID, string sPlayerName, string sIP, string sCDKey, int iPrivileges);
void Heimdall_OpenRegisterGUI(int iUniquePlayerID, string sPlayerName, string sIP, string sCDKey, int iPrivileges);
void Heimdall_OpenKickGui(int iUniquePlayerID, string sPlayerName, string sIP, string sCDKey, int iPrivileges, string sMsg);

const string SEPT_HEIMDALL_RETRIES = "sept_heimdall_retries_";

#include "sept_heimdall_config"

string ReplaceTokens(string sMsg, string sToken, string sValue)
{
	int nTokLen = GetStringLength(sToken);
	int nPos = 0;
	while ((nPos = FindSubString(sMsg, sToken, nPos)) >= 0) {
		sMsg = GetStringLeft(sMsg, nPos) + sValue + GetSubString(sMsg, nPos + nTokLen, -1);
	}
	return sMsg;
}